/*
 * Decompiled with CFR 0.152.
 */
package pse.assessment;

import org.w3c.dom.Node;
import pse.assessment.AssessmentObject;
import pse.assessment.ConsistencyChecker;
import pse.assessment.InitialNetwork;
import pse.common.FileInfo;
import pse.util.general.XmlUtils;
import pse.util.general.XmlWriter;

public class MediaObjectMetaData
extends AssessmentObject {
    protected FileInfo fileInfo;
    protected InitialNetwork initialNetwork;
    protected String pkaTimestamp;
    protected String pseVersion;
    protected String ptVersion;

    public boolean isTaskObject() {
        return true;
    }

    public void checkForConsistency(ConsistencyChecker consistencyChecker) {
        String string;
        if (this.fileInfo != null && (string = this.fileInfo.getFileName()) != null) {
            boolean bl;
            boolean bl2 = consistencyChecker.hasFile(string);
            boolean bl3 = bl = this.fileInfo.getContents() != null;
            if (!bl2 && !bl) {
                consistencyChecker.missingFile(this, string);
            }
        }
        if (this.initialNetwork != null) {
            this.initialNetwork.checkForConsistency(consistencyChecker);
        }
    }

    public String getElementName() {
        return "media-object-metadata";
    }

    public boolean hasAttributes() {
        return true;
    }

    public boolean hasChildren() {
        return super.hasChildren() || this.fileInfo != null || this.initialNetwork != null;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public InitialNetwork getInitialNetwork() {
        return this.initialNetwork;
    }

    public void setInitialNetwork(InitialNetwork initialNetwork) {
        this.initialNetwork = initialNetwork;
    }

    public String getPkaTimestamp() {
        return this.pkaTimestamp;
    }

    public void setPkaTimestamp(String string) {
        this.pkaTimestamp = string;
    }

    public String getPseVersion() {
        return this.pseVersion;
    }

    public void setPseVersion(String string) {
        this.pseVersion = string;
    }

    public String getPtVersion() {
        return this.ptVersion;
    }

    public void setPtVersion(String string) {
        this.ptVersion = string;
    }

    protected void addAttributes(XmlWriter xmlWriter) {
        super.addAttributes(xmlWriter);
        xmlWriter.addAttribute("pt-version", this.ptVersion);
        xmlWriter.addAttribute("pka-timestamp", this.pkaTimestamp);
        xmlWriter.addAttribute("pse-version", this.pseVersion);
    }

    protected void addChildren(XmlWriter xmlWriter) {
        super.addChildren(xmlWriter);
        xmlWriter.openElement("pka-info");
        this.addChild(xmlWriter, this.fileInfo);
        this.addChild(xmlWriter, this.initialNetwork);
        xmlWriter.closeElement();
    }

    protected void readAttributes(Node node) {
        super.readAttributes(node);
        this.ptVersion = XmlUtils.getAttribute(node, "pt-version");
        this.pkaTimestamp = XmlUtils.getAttribute(node, "pka-timestamp");
        this.pseVersion = XmlUtils.getAttribute(node, "pse-version");
    }

    protected void readChildrenFromMyNode(Node node) {
        super.readChildrenFromMyNode(node);
        Node node2 = XmlUtils.getChild(node, "pka-info");
        this.fileInfo = (FileInfo)this.readChild(node2, new FileInfo());
        this.initialNetwork = (InitialNetwork)this.readChild(node2, new InitialNetwork());
    }
}

